;-----------------------------------------------------------------------------
; AutoIt Version: 3.2.2.0
; Author:Andrew Calcutt 	Last Edited:11/07/2007
; Script Function:	Sets up INI file for _no_gui.exe
$PrepsysVersion = 'v0.97 beta'
;-----------------------------------------------------------------------------
AutoItSetOption("RunErrorsFatal", 0) ;Do not show errors if run error
#include <GUIConstants.au3>
#include <GuiListView.au3>
#include <string.au3>
#include <File.au3>
#include <Array.au3>
#include <Process.au3>
#include <PrepSys\PrepSysFunc.au3> ;My Defined Functions for PrepSys
$objError = ObjEvent("AutoIt.Error", "_objErr")
; ----------------------------------------------------------------------------
;<-- Declair Variables -->, good luck if you need to change any of these
Dim $addautorun, $addofficetoolbar, $addprepsystostartup, $AdminDomains, $APTS_PrepsysLocation, $APTS_settingsfile, $APTS_settingsfile_Combo, $APTS_tab, $AutoHideTaskbar, $AutorunPrepsysOnStartup, $AWWMAM
Dim $bowse_ini, $browse_toolbar_dir, $browse1, $browse2, $browse3, $browse4, $browse5, $browse6, $browse7, $browse8, $browse9, $BrowsePrepsysLocation, $BrowseSettingsFile
Dim $CacheThumbnails, $Classic_Menu, $cleandesk, $cleansms, $cleansms_exe, $cleansms_exe2, $ControlPanelInMyComputer, $copyprofile, $CPDomains, $cpgroup, $cplabel1, $cplabel2, $cplabel3
Dim $datatel, $datatel_exe, $datatel_exe2, $deepfreeze, $deepfreeze_exe, $deepfreeze_exe2, $defaultimgname, $defragment, $deleteautorun, $DeleteCopyProfileUser, $deleteini, $DisplayAdminTools, $DisplayFavories, $DisplayFileSizeInFolderTips, $DisplayLogOff, $DisplayRun, $DisplaySystemFolderContents, $domain, $domain2
Dim $EnableDRAGandDROP, $EnableDragDrop, $exit_prepsys, $ExpandControlPanel, $ExpandMyDocuments, $ExpandMyPictures, $ExpandNetworkConnections, $ExpandPrinters, $extra_exe2, $extrainstall, $extralist, $extrareboot
Dim $folderoptions, $FOSMIV, $FOSTIV, $FullPathAddress, $FullPathTitle, $Group, $group1, $HideInactiveIcons, $iexplorer, $imglab1, $imglab2, $inifile_browse
Dim $JD_domain, $JDdomain, $JDpassword, $JDusername, $join_to, $joindomain, $jointo, $JTlabel, $KeepTaskbarOnTop, $action_progress, $wininstaller
Dim $label1, $label2, $label3, $LaunchWindowsInSeperateProcess, $load_ini, $localimgname, $LockTaskbar, $logondomain1, $logondomain2, $logonpass1, $logonpass2, $logonuser1, $logonuser2
Dim $machine_name, $MakeJDUserAdmin, $mcafee_exe, $mcafee_exe2, $mcafee_patch_exe, $wininstaller_exe, $wininstaller_exe2, $mcafee_patch_exe2, $mcguid, $mcinstall, $MNlabel, $mycomp, $mydocs, $mynetplaces
Dim $netdom, $netpass, $netuser, $new_ini, $office_exe, $office_exe2, $offinstall, $offtool, $opentotab, $OUdata, $OUdomain, $OUnames, $OUuserdomains
Dim $password, $password2, $PrepsysLocation, $PWLabel, $RememberFolderSettings, $RemoveJDAdminRights, $remuser, $RestoreWindowsAtLogon, $runsysprep
Dim $satlabel, $save_ini, $save_ini_as, $scplabel, $ScrollPrograms, $ScrollPrograms2, $SearchNetPrinters, $SEOSF, $setinirun, $ShowAdminTools, $ShowClock, $ShowCompressedFilesInColor, $ShowControlPanel, $ShowDesktopFolderInfoPopop, $ShowFileExtensions, $ShowHelp, $ShowHiddenFiles, $ShowHiddenSysFiles, $ShowMyComputer, $ShowMyDocs, $ShowMyMusic
Dim $ShowMyPics, $ShowNetConn, $shownetlogonprompt, $shownetprompt, $ShowPrinters, $ShowQuickLaunch, $ShowRun, $ShowSearch, $ShowSetProgramAccessAndDefaults, $SimpleViewInFolderListView, $smclabel, $smdlabel, $smmlabel, $smplabel, $snclabel, $SOCB, $sophos_exe, $sophos_exe2, $spinstall, $SSLB, $SSUM, $SSUMP, $startmenu, $StartMenuFavorites, $STB, $STSR, $SWCWD
Dim $tab, $toolbar_group, $toolbardir, $toolbardir2, $UABIFEFT, $UCTIF, $UDlabel, $UDSFILOTD, $UNLabel, $use_local_image, $UseJDUserAsCopyProfileUser
Dim $UseJDUserAsDefaultAdmin, $UsePersonalizedMenus, $user_create, $user_existing, $username, $username2, $UseSimpleFileSharing, $UVSOWAB, $vissettings, $vpn_exe, $vpn_exe2, $vpninstall, $waitupdate, $workingdir, $UseServiceTagAsName
Dim $turnoffautoupdate, $deleteiconcache
Dim $progressref = 0, $progressref2 = 0, $requestnetwork = 0
Dim $no_gui_exe = @HomeDrive & "\_no_gui.exe"

Dim $AutoRunPrepSys = 0, $settings = '', $cmdsettingsfile = '', $settingsfile = '', $opentab[3]
;<-- End Declair Variables -->
;<-- Start Command Line Input -->
$opentab[2] = 1
For $loop = 1 To $CmdLine[0]
	If StringInStr($CmdLine[$loop], '/r') Then $AutoRunPrepSys = 1 ;Set Prepsys to AutoRun w/selected settings file
	If StringInStr($CmdLine[$loop], '/s') Then ;Set ini file
		$inifile = StringSplit($CmdLine[$loop], '=')
		$cmdsettingsfile = $inifile[2]
	EndIf
	If StringInStr($CmdLine[$loop], '/t') Then
		$opentab = StringSplit($CmdLine[$loop], '=')
	EndIf
	If StringInStr($CmdLine[$loop], '/?') Then
		Run("notepad.exe syntax.txt")
		Exit
	EndIf
Next
;<-- End Command Line Input -->

;<-- Settings File Array/Defaults -->
$settingslist = _FileListToArray(@ScriptDir & '\settings', '*.ini', 1);make array of files in @ScriptDir\settings\
If IsArray($settingslist) And @error <> 1 Then
	For $addfiles = 1 To $settingslist[0]
		If $settingslist[$addfiles] = 'default.ini' Then $settingsfile = 'default.ini'
		If $settingsfile <> 'default.ini' Then $settingsfile = $settingslist[$addfiles]
	Next
	If FileExists(@HomeDrive & '\settings.ini') Then ;If settings.ini is on homedrive, make it the default ini
		$settingsfile = @HomeDrive & '\settings.ini'
		_ArrayAdd($settingslist, $settingsfile)
		$settingslist[0] = UBound($settingslist) - 1
	EndIf
	If $cmdsettingsfile <> '' Then ;If File was specified, make default ini
		$settingsfile = $cmdsettingsfile
		_ArrayAdd($settingslist, $settingsfile)
		$settingslist[0] = UBound($settingslist) - 1
	EndIf
	If StringInStr($settingsfile, ":") = 0 And StringInStr($settingsfile, "\\") = 0 Then ;if full path for settings file is not given, assume file is in @scriptdir/settings/
		$settings = @ScriptDir & "\settings\" & $settingsfile
	Else
		$settings = $settingsfile
	EndIf
EndIf
;<-- End Settings File Array/Defaults -- >
;---------------------------------------------------------------------------------------------------------------------------------------------------------------------------


;Run XP GUI - Hoping to have a vista GUI soon
While 1
	_XP_Prepsys()
WEnd

Func _XP_Prepsys()
	Dim $AdminDomains[1]
	Dim $CPDomains[1]
	Dim $OUnames[1]
	Dim $OUdata[1]
	Dim $OUdomain[1]
	Dim $OUuserdomains[1]
	;-----------------------------------------------------------------------------
	;declair variables
	$machine_name_orig = IniRead($settings, "JoinDomain", "MachineName", @ComputerName)
	$workingdir = @ScriptDir
	If StringInStr(StringTrimLeft($workingdir, StringLen($workingdir) - 1), '\') = 0 Then $workingdir = $workingdir & '\' ;If the last character is not a "\", add "\" to the end of the string
	$logonuser1 = IniRead($settings, "Script_Settings", "Admin_Username", "")
	$logonpass1 = _StringEncrypt(0, IniRead($settings, "Script_Settings", "Admin_Password", ""), "Prepsys", 2)
	$logondomain1 = IniRead($settings, "Script_Settings", "Admin_Domain", @ComputerName)
	$logonuser2 = IniRead($settings, "Script_Settings", "Sysprep_Username", "")
	$logonpass2 = _StringEncrypt(0, IniRead($settings, "Script_Settings", "Sysprep_Password", ""), "Prepsys", 2)
	$logondomain2 = IniRead($settings, "Script_Settings", "Sysprep_Domain", @ComputerName)


	$defaultimgname = IniRead($settings, "Background", "Default_Image", "")
	$localimgname = IniRead($settings, "Background", "Local_Image", "")

	$mcafee_exe = IniRead($settings, "Program_Locations", "mcafee_exe", '"' & $workingdir & 'Extra\McAfee\AutoInstall_McAfee.exe"')
	$mcafee_patch_exe = IniRead($settings, "Program_Locations", "mcafee_patch_exe", '"' & $workingdir & 'Extra\McAfee\Patch\AutoInstall_McAfee_Patch.exe"')
	$sophos_exe = IniRead($settings, "Program_Locations", "sophos_exe", '"' & $workingdir & 'Extra\Sophos\AutoInstall_Sophos.exe"')
	$vpn_exe = IniRead($settings, "Program_Locations", "vpn_exe", '"' & $workingdir & 'Extra\VPN\AutoInstall_VPN.exe"')
	$office_exe = IniRead($settings, "Program_Locations", "office_exe", '"' & $workingdir & 'Extra\OFFICE\AutoInstall_Office.exe"')
	$datatel_exe = IniRead($settings, "Program_Locations", "datatel_exe", '"' & $workingdir & 'Extra\DATATEL\AutoInstall_Datatel.exe"')
	$deepfreeze_exe = IniRead($settings, "Program_Locations", "deepfreeze_exe", '"' & $workingdir & 'Extra\Deepfreeze\DFSeed.bat"')
	$cleansms_exe = IniRead($settings, "Program_Locations", "cleansms_exe", '"' & $workingdir & 'Extra\CleanSMS\AutoRun_cleansms.exe"')
	$wininstaller_exe = IniRead($settings, "Program_Locations", "wininstaller_exe", '"' & $workingdir & 'Extra\WindowsInstaller\WindowsInstaller-KB893803-v2-x86.exe" /passive /norestart')

	$netuser = IniRead($settings, "NetworkLogon", "NetAdmin", "")
	$netpass = _StringEncrypt(0, IniRead($settings, "NetworkLogon", "NetPass", ""), "Prepsys", 2)
	$netdom = IniRead($settings, "NetworkLogon", "NetDom", "")
	$shownetprompt = IniRead($settings, "NetworkLogon", "ShowNetLoginPrompt", "1")

	$toolbardir = IniRead($settings, "OFFICE", "OfficeToolbarDir", "C:\Documents and Settings\All Users\Start Menu\Programs\Microsoft Office")
	$JDusername = IniRead($settings, "JoinDomain", "Username", "")
	$JDpassword = _StringEncrypt(0, IniRead($settings, "JoinDomain", "Password", ""), "Prepsys", 2)

	$JDdomain = IniRead($settings, "JoinDomain", "Domain", "")
	$jointo = IniRead($settings, "JoinDomain", "OUdefault", "")

	$APTS_PrepsysLocation = IniRead($settings, "Program_Use_Only", "APTS_PrepsysLocation", @ScriptFullPath)
	$APTS_settingsfile = IniRead($settings, "Program_Use_Only", "APTS_settingsfile", "default.ini")
	$APTS_tab = IniRead($settings, "Program_Use_Only", "APTS_tab", "1")

	;-----------------------------------------------------------------------------
	;<-- End Set $workingdir -->
	$PrepsysTitleBar = 'PrepSys ' & $PrepsysVersion & ' - By Andrew Calcutt - ' & $settingsfile
	$Prepsys_Window = GUICreate($PrepsysTitleBar, 585, 530, 251, 147)
	;<-- Settings File ComboBox -->
	$inifile_browse = GUICtrlCreateCombo("", 8, 8, 570, 25)
	If IsArray($settingslist) And @error <> 1 Then
		For $addfiles = 1 To $settingslist[0]
			If $settingslist[$addfiles] = $settingsfile Then GUICtrlSetData($inifile_browse, $settingslist[$addfiles], $settingsfile); if default.ini then add to list and select
			If $settingslist[$addfiles] <> $settingsfile Then GUICtrlSetData($inifile_browse, $settingslist[$addfiles]); if not default.ini the add to list and don't select
		Next
	EndIf
	;<-- End Settings File ComboBox -->

	;<-- Main Window Buttons -->
	$load_ini = GUICtrlCreateButton("Load ini", 55, 35, 75, 17, 0)
	$bowse_ini = GUICtrlCreateButton("Browse for ini", 135, 35, 75, 17, 0)
	$save_ini = GUICtrlCreateButton("Save ini", 215, 35, 75, 17, 0)
	$save_ini_as = GUICtrlCreateButton("Save ini As", 295, 35, 75, 17, 0)
	$setinirun = GUICtrlCreateButton("Run", 375, 35, 75, 17, 0)
	$exit_prepsys = GUICtrlCreateButton("Exit", 455, 35, 75, 17, 0)
	$tab = GUICtrlCreateTab(0, 56, 585, 450)
	GUICtrlCreateLabel("Program by: Andrew Calcutt", 224, 512, 135, 17)
	;<-- End Main window buttons -->

	$Tab1 = GUICtrlCreateTabItem("General");--->General Settings Tab
	If $opentab[2] = 1 Then GUICtrlSetState(-1, $GUI_SHOW) ;Display General Tab First
	;Start - Run Group
	GUICtrlCreateGroup("Run", 5, 85, 160, 385)
	_IniReadCheckbox_Ran ($settings, $remuser, "Remove Initial User", "Script_Settings", "Delete_Start_User", "Program_Use_Only", "Delete_Start_User_Step2", 10, 105, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $joindomain, "Join Domain", "Script_Settings", "Join_To_Domain", "Program_Use_Only", "Joined_To_Domain", 10, 120, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $wininstaller, "Install Windows Installer", "Script_Settings", "Install_WinInstaller", "Program_Use_Only", "Installed_WinInstaller", 10, 135, 130, 15, 145)
	_IniReadCheckbox_Ran ($settings, $mcinstall, "Install McAffe", "Script_Settings", "Install_McAfee", "Program_Use_Only", "Installed_McAfee", 10, 150, 110, 15, 145)
	If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\TVD\VirusScan Enterprise\CurrentVersion", "szProductVer") <> "" Then GUICtrlCreatePic($workingdir & "PrepSys\installed.bmp", 130, 150, 15, 15)
	_IniReadCheckbox_Ran ($settings, $spinstall, "Install Sophos", "Script_Settings", "Install_Sophos", "Program_Use_Only", "Installed_Sophos", 10, 165, 110, 15, 145)
	If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Sophos\SweepNT", "Default") = "" Then GUICtrlCreatePic($workingdir & "PrepSys\installed.bmp", 130, 165, 15, 15)
	_IniReadCheckbox_Ran ($settings, $vpninstall, "Install VPN", "Script_Settings", "Install_VPN", "Program_Use_Only", "Installed_VPN", 10, 180, 110, 15, 145)
	If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Cisco Systems\VPN Client", "InstallPath") <> "" Then GUICtrlCreatePic($workingdir & "PrepSys\installed.bmp", 130, 180, 15, 15)
	_IniReadCheckbox_Ran ($settings, $offinstall, "Install Office", "Script_Settings", "Install_Office", "Program_Use_Only", "Installed_Office", 10, 195, 110, 15, 145)
	If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\11.0\Common\InstallRoot", "Path") <> "" Then GUICtrlCreatePic($workingdir & "PrepSys\installed.bmp", 130, 195, 15, 15)
	_IniReadCheckbox_Ran ($settings, $addofficetoolbar, "Add Office Toolbar", "Script_Settings", "AddOfficeToolbar", "Program_Use_Only", "Added_Office_Toolbar", 10, 210, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $datatel, "Install Datatel", "Script_Settings", "Install_Datatel", "Program_Use_Only", "Installed_Datatel", 10, 225, 110, 15, 145)
	If FileExists("C:\DATATEL\") Then GUICtrlCreatePic($workingdir & "PrepSys\installed.bmp", 130, 225, 15, 15)
	_IniReadCheckbox_Ran ($settings, $deepfreeze, "Install DeepFreeze", "Script_Settings", "Install_DeepFreeze", "Program_Use_Only", "Installed_DeepFreeze", 10, 240, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $extrainstall, "Install Extra Program(s)", "Script_Settings", "Run_Extra", "Program_Use_Only", "Ran_Extra", 10, 255, 125, 15, 145)
	_IniReadCheckbox_Ran ($settings, $startmenu, "Set Start Menu Settings", "Script_Settings", "Set_Start_Menu", "Program_Use_Only", "Set_Start_Menu", 10, 270, 135, 15, 145)
	_IniReadCheckbox_Ran ($settings, $vissettings, "Set Visual Settings", "Script_Settings", "Set_Visual_Settings", "Program_Use_Only", "Set_Visual_Settings", 10, 285, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $folderoptions, "Set Folder Settings", "Script_Settings", "Set_Folder_Options", "Program_Use_Only", "Set_Folder_Options", 10, 300, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $waitupdate, "Wait to Update", "Script_Settings", "Wait_Updates", "Program_Use_Only", "Waited_For_Updates", 10, 315, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $deleteiconcache, "Delete Iconcache", "Script_Settings", "DeleteIconCache", "Program_Use_Only", "DeleteIconCache", 10, 330, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $copyprofile, "Copy Profile", "Script_Settings", "Copy_Profile", "Program_Use_Only", "Copy_Profile_Step3", 10, 345, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $turnoffautoupdate, "Auto Update Off", "Script_Settings", "AutoUpdate", "Program_Use_Only", "AutoUpdate", 10, 360, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $cleansms, "Clean SMS", "Script_Settings", "Clean_SMS", "Program_Use_Only", "Cleaned_SMS", 10, 375, 110, 15, 145)
	_IniReadCheckbox_Ran ($settings, $mcguid, "Remove McAffe GUID", "Script_Settings", "Remove_McAfee_GUID", "Program_Use_Only", "Removed_McAfee_GUID", 10, 390, 125, 15, 145)
	_IniReadCheckbox_Ran ($settings, $defragment, "Defragment", "Script_Settings", "Defrag", "Program_Use_Only", "Defraged", 10, 405, 110, 15, 145)
	_IniReadCheckbox ($settings, $runsysprep, "Run Sysprep", "Script_Settings", "Run_Sysprep", 10, 420, 130, 15)
	_IniReadCheckbox ($settings, $addprepsystostartup, "Add PrepSys to Startup", "Script_Settings", "addprepsystostartup", 10, 435, 130, 15)
	_IniReadCheckbox ($settings, $deleteini, "Delete " & @HomeDrive & "\settings.ini", "Script_Settings", "Delete_INI", 10, 450, 130, 15)
	GUICtrlCreateGroup("Logon Information", 170, 85, 225, 130)
	GUICtrlCreateLabel("Default Admin User", 175, 105, 120, 15)
	$username = GUICtrlCreateInput($logonuser1, 175, 120, 215, 20)
	GUICtrlCreateLabel("Default Admin Pass", 175, 140, 120, 15)
	$password = GUICtrlCreateInput($logonpass1, 175, 155, 215, 20, $ES_PASSWORD)
	GUICtrlCreateLabel("Default Admin Domain", 175, 175, 120, 15)


	$domain = GUICtrlCreateCombo("", 175, 190, 170, 20)
	$Admin_Domains = IniReadSection($settings, "Admin_Domains")
	_ArrayAdd($AdminDomains, @ComputerName)
	GUICtrlSetData($domain, $AdminDomains[1], @ComputerName)
	If IsArray($Admin_Domains) Then
		For $i = 1 To $Admin_Domains[0][0]
			If $Admin_Domains[$i][1] = $logondomain1 Then
				GUICtrlSetData($domain, $Admin_Domains[$i][1], $logondomain1)
			Else
				GUICtrlSetData($domain, $Admin_Domains[$i][1])
			EndIf
			_ArrayAdd($AdminDomains, $Admin_Domains[$i][1])
			$AdminDomains[0] = UBound($AdminDomains) - 1
		Next
	EndIf
	$AddCompDomain = GUICtrlCreateButton("+", 350, 190, 20, 20)
	$RemCompDomain = GUICtrlCreateButton("-", 370, 190, 20, 20)






	;$domain = GUICtrlCreateInput($logondomain1, 175, 130, 215, 20)
	$cpgroup = GUICtrlCreateGroup("Copy Profile User", 170, 220, 225, 200)
	$user_create = GUICtrlCreateRadio("Create Temporary User", 175, 240, 140, 20)
	$user_existing = GUICtrlCreateRadio("User Existing User", 175, 260, 140, 20)
	If IniRead($settings, "Program_Use_Only", "CreateCopyProfileUser", "1") = 1 Then
		GUICtrlSetState($user_create, $GUI_CHECKED)
	Else
		GUICtrlSetState($user_existing, $GUI_CHECKED)
	EndIf
	$cplabel1 = GUICtrlCreateLabel("Copy Profile User", 175, 280, 120, 15)
	$username2 = GUICtrlCreateInput($logonuser2, 175, 295, 215, 20)
	$cplabel2 = GUICtrlCreateLabel("Copy Profile Pass (Strong)", 175, 315, 150, 15)
	$password2 = GUICtrlCreateInput($logonpass2, 175, 330, 215, 20, $ES_PASSWORD)
	$cplabel3 = GUICtrlCreateLabel("Copy Profile Domain", 175, 350, 120, 15)
	;$domain2 = GUICtrlCreateInput($logondomain2, 175, 305, 215, 20)

	$domain2 = GUICtrlCreateCombo("", 175, 365, 170, 20)
	$CP_Domains = IniReadSection($settings, "CP_Domains")
	_ArrayAdd($CPDomains, @ComputerName)
	GUICtrlSetData($domain2, $CPDomains[1], @ComputerName)
	If IsArray($CP_Domains) Then
		For $i = 1 To $CP_Domains[0][0]
			If $CP_Domains[$i][1] = $logondomain2 Then
				GUICtrlSetData($domain2, $CP_Domains[$i][1], $logondomain2)
			Else
				GUICtrlSetData($domain2, $CP_Domains[$i][1])
			EndIf
			_ArrayAdd($CPDomains, $CP_Domains[$i][1])
			$CPDomains[0] = UBound($CPDomains) - 1
		Next
	EndIf
	$AddCompDomain2 = GUICtrlCreateButton("+", 350, 365, 20, 20)
	$RemCompDomain2 = GUICtrlCreateButton("-", 370, 365, 20, 20)


	_IniReadCheckbox ($settings, $DeleteCopyProfileUser, "Delete user after Copy Profile", "Program_Use_Only", "DeleteCopyProfileUser", 175, 395, 205, 15)
	_IniReadCheckbox ($settings, $shownetlogonprompt, "Show network logon prompt (if needed)", "NetworkLogon", "ShowNetLoginPrompt", 175, 425, 205, 15, 1)
	
	$group1 = GUICtrlCreateGroup("Add PrepSys to Startup", 400, 85, 180, 210)
	$label1 = GUICtrlCreateLabel("PrepSys exe:", 405, 105, 80, 15)
	$PrepsysLocation = GUICtrlCreateInput($APTS_PrepsysLocation, 405, 120, 170, 20)
	$BrowsePrepsysLocation = GUICtrlCreateButton("Browse", 405, 140, 60, 20)
	$label2 = GUICtrlCreateLabel("Settings File:", 405, 170, 80, 15)
	$APTS_settingsfile_Combo = GUICtrlCreateCombo("", 405, 185, 170, 20)
	If IsArray($settingslist) And @error <> 1 Then
		For $addfiles = 1 To $settingslist[0]
			If $settingslist[$addfiles] = $APTS_settingsfile Then GUICtrlSetData($APTS_settingsfile_Combo, $settingslist[$addfiles], $APTS_settingsfile); if default.ini then add to list and select
			If $settingslist[$addfiles] <> $APTS_settingsfile Then GUICtrlSetData($APTS_settingsfile_Combo, $settingslist[$addfiles]); if not default.ini the add to list and don't select
		Next
	EndIf
	$BrowseSettingsFile = GUICtrlCreateButton("Browse", 405, 205, 60, 20)
	_IniReadCheckbox ($settings, $AutorunPrepsysOnStartup, "AutoRun on Startup", "Program_Use_Only", "AutorunPrepsysOnStartup", 405, 235, 170, 20)
	$label3 = GUICtrlCreateLabel("Open to Tab:", 405, 265, 70, 20)
	$opentotab = GUICtrlCreateInput($APTS_tab, 480, 265, 30, 20)

	$tab2 = GUICtrlCreateTabItem("Join Domain") ;--->Start Menu Settings Tab
	If $opentab[2] = 2 Then GUICtrlSetState(-1, $GUI_SHOW)
	$MNlabel = GUICtrlCreateLabel("Machine Name:", 10, 110, 80, 20)
	$machine_name = GUICtrlCreateInput($machine_name_orig, 100, 110, 370, 20)
	$JTlabel = GUICtrlCreateLabel("Join To:", 10, 140, 90, 20)
	$join_to = GUICtrlCreateCombo("", 100, 140, 290, 20)
	$editOU = GUICtrlCreateButton("Edit", 400, 140, 30, 20)
	$addOU = GUICtrlCreateButton("+", 430, 140, 20, 20)
	$removeOU = GUICtrlCreateButton("-", 450, 140, 20, 20)

	;Add OUs to $join_to combo
	$OU_Options = IniReadSection($settings, "Join_Domain_OU")
	$OU_Domains = IniReadSection($settings, "Join_Domain")
	If Not @error Then
		For $i = 1 To $OU_Options[0][0]
			If $jointo = $OU_Options[$i][0]Then
				GUICtrlSetData($join_to, $OU_Options[$i][0], $OU_Options[$i][0])
			Else
				GUICtrlSetData($join_to, $OU_Options[$i][0])
			EndIf
			_ArrayAdd($OUnames, $OU_Options[$i][0])
			_ArrayAdd($OUdata, $OU_Options[$i][1])
			_ArrayAdd($OUdomain, $OU_Domains[$i][1])
			$OUnames[0] = UBound($OUnames) - 1
			$OUdomain[0] = UBound($OUdomain) - 1
			$OUdata[0] = UBound($OUnames) - 1
		Next
	EndIf

	$UNLabel = GUICtrlCreateLabel("Username:", 10, 170, 90, 20)
	$JDusername = GUICtrlCreateInput($JDusername, 100, 170, 370, 20)
	$PWLabel = GUICtrlCreateLabel("Password:", 10, 200, 90, 20)
	$JDpassword = GUICtrlCreateInput($JDpassword, 100, 200, 370, 20, $ES_PASSWORD)
	$UDlabel = GUICtrlCreateLabel("User Domain:", 10, 230, 80, 20)
	$JD_domain = GUICtrlCreateCombo("", 100, 230, 320, 20)


	$OU_User_Domains = IniReadSection($settings, "OU_User_Domains")
	If Not @error Then
		For $i = 1 To $OU_User_Domains[0][0]
			If $JDdomain = $OU_User_Domains[$i][1]Then
				GUICtrlSetData($JD_domain, $OU_User_Domains[$i][1], $OU_User_Domains[$i][1])
			Else
				GUICtrlSetData($JD_domain, $OU_User_Domains[$i][1])
			EndIf
			_ArrayAdd($OUuserdomains, $OU_User_Domains[$i][1])
			$OUuserdomains[0] = UBound($OUuserdomains) - 1
		Next
	EndIf
	$OU_AddUserDomain = GUICtrlCreateButton("+", 430, 230, 20, 20)
	$OU_RemoveUserDomain = GUICtrlCreateButton("-", 450, 230, 20, 20)


	_IniReadCheckbox ($settings, $MakeJDUserAdmin, "Make User Administrator", "Program_Use_Only", "MakeJDUserAdmin", 10, 260, 400, 15)
	_IniReadCheckbox ($settings, $UseJDUserAsDefaultAdmin, "Use Join Domain User As Default Admin User After joined", "Program_Use_Only", "UseJDUserAsDefaultAdmin", 10, 280, 400, 15)
	_IniReadCheckbox ($settings, $UseJDUserAsCopyProfileUser, "Use Join Domain User As Copy Profile User After joined", "Program_Use_Only", "UseJDUserAsCopyProfileUser", 10, 300, 400, 15)
	_IniReadCheckbox ($settings, $RemoveJDAdminRights, "Remove Join Domain User Admin Rights when script finishes", "Program_Use_Only", "RemoveJDAdminRights", 10, 320, 400, 15)
	_IniReadCheckbox ($settings, $UseServiceTagAsName, 'Use "D" and the service tag for the computer name', "Program_Use_Only", "UseServiceTagAsName", 10, 340, 400, 15)

	;GUICtrlSetData($JDdomain,"ACL|WSC_DOMAIN","WSC_DOMAIN")

	$tab3 = GUICtrlCreateTabItem("Start Menu/Folder") ;--->Start Menu Settings Tab
	If $opentab[2] = 3 Then GUICtrlSetState(-1, $GUI_SHOW)
	_IniReadCheckbox ($settings, $Classic_Menu, "Use Classic Menu", "StartMenu", "Classic_Menu", 10, 85, 160, 15)
	GUICtrlCreateGroup("Start Menu/TaskBar Settings", 5, 105, 205, 320)
	_LabeledCombo ($settings, $ShowControlPanel, $scplabel, "Control Panel", "StartMenu", "ShowControlPanel", "Disabled", "Link", "Menu", 90, 125, 115, 20, 10, 85, 80, 15)
	_LabeledCombo ($settings, $ShowMyComputer, $smclabel, "My Computer", "StartMenu", "ShowMyComputer", "Disabled", "Link", "Menu", 90, 145, 115, 20, 10, 105, 80, 15)
	_LabeledCombo ($settings, $ShowMyDocs, $smdlabel, "My Documents", "StartMenu", "ShowMyDocs", "Disabled", "Link", "Menu", 90, 165, 115, 20, 10, 125, 80, 15)
	_LabeledCombo ($settings, $ShowMyMusic, $smmlabel, "My Music", "StartMenu", "ShowMyMusic", "Disabled", "Link", "Menu", 90, 185, 115, 20, 10, 145, 80, 15)
	_LabeledCombo ($settings, $ShowMyPics, $smplabel, "My Pictures", "StartMenu", "ShowMyPics", "Disabled", "Link", "Menu", 90, 205, 115, 20, 10, 165, 80, 15)
	_LabeledCombo ($settings, $ShowNetConn, $snclabel, "Network", "StartMenu", "ShowNetConn", "Disabled", "Net Connections", "Connect to", 90, 225, 115, 20, 10, 185, 80, 15)
	_LabeledCombo ($settings, $ShowAdminTools, $satlabel, "Admin Tools", "StartMenu", "ShowAdminTools", "Disabled", "Programs", "Start menu + progs", 90, 245, 115, 20, 10, 205, 80, 15)
	_IniReadCheckbox ($settings, $ShowSetProgramAccessAndDefaults, "Program Access And Defaults", "StartMenu", "ShowSetProgramAccessAndDefaults", 10, 270, 160, 15)
	_IniReadCheckbox ($settings, $StartMenuFavorites, "Start Menu Favorites", "StartMenu", "StartMenuFavorites", 10, 285, 160, 15)
	_IniReadCheckbox ($settings, $EnableDragDrop, "Enable Drag Drop", "StartMenu", "EnableDragDrop", 10, 300, 160, 15)
	_IniReadCheckbox ($settings, $ScrollPrograms2, "Scroll Programs", "StartMenu", "ScrollPrograms", 10, 315, 160, 15)
	_IniReadCheckbox ($settings, $ShowHelp, "Show Help", "StartMenu", "ShowHelp", 10, 330, 160, 15)
	_IniReadCheckbox ($settings, $ShowPrinters, "Show Printers", "StartMenu", "ShowPrinters", 10, 345, 160, 15)
	_IniReadCheckbox ($settings, $ShowRun, "Show Run", "StartMenu", "ShowRun", 10, 360, 160, 15)
	_IniReadCheckbox ($settings, $ShowSearch, "Show Search", "StartMenu", "ShowSearch", 10, 375, 160, 15)

	GUICtrlCreateGroup("Classic Menu Settings", 215, 85, 180, 205)
	_IniReadCheckbox ($settings, $DisplayAdminTools, "Display Admin Tools", "Classic_Menu_Options", "DisplayAdminTools", 220, 105, 160, 15)
	_IniReadCheckbox ($settings, $DisplayFavories, "Display Favories", "Classic_Menu_Options", "DisplayFavories", 220, 120, 160, 15)
	_IniReadCheckbox ($settings, $DisplayLogOff, "Display LogOff", "Classic_Menu_Options", "DisplayLogOff", 220, 135, 160, 15)
	_IniReadCheckbox ($settings, $DisplayRun, "Display Run", "Classic_Menu_Options", "DisplayRun", 220, 150, 160, 15)
	_IniReadCheckbox ($settings, $EnableDRAGandDROP, "Enable DRAG and DROP", "Classic_Menu_Options", "EnableDRAGandDROP", 220, 165, 160, 15)
	_IniReadCheckbox ($settings, $ExpandControlPanel, "Expand Control Panel", "Classic_Menu_Options", "ExpandControlPanel", 220, 180, 160, 15)
	_IniReadCheckbox ($settings, $ExpandMyDocuments, "Expand My Documents", "Classic_Menu_Options", "ExpandMyDocuments", 220, 195, 160, 15)
	_IniReadCheckbox ($settings, $ExpandMyPictures, "Expand My Pictures", "Classic_Menu_Options", "ExpandMyPictures", 220, 210, 160, 15)
	_IniReadCheckbox ($settings, $ExpandNetworkConnections, "Expand Network Connections", "Classic_Menu_Options", "ExpandNetworkConnections", 220, 225, 160, 15)
	_IniReadCheckbox ($settings, $ExpandPrinters, "Expand Printers", "Classic_Menu_Options", "ExpandPrinters", 220, 240, 160, 15)
	_IniReadCheckbox ($settings, $ScrollPrograms, "Scroll Programs", "Classic_Menu_Options", "ScrollPrograms", 220, 255, 160, 15)
	_IniReadCheckbox ($settings, $UsePersonalizedMenus, "Use Personalized Menus", "Classic_Menu_Options", "UsePersonalizedMenus", 220, 270, 160, 15)

	GUICtrlCreateGroup("Taskbar Settings", 215, 290, 180, 135)
	_IniReadCheckbox ($settings, $LockTaskbar, "Lock Taskbar", "Taskbar", "LockTaskbar", 220, 310, 160, 15)
	_IniReadCheckbox ($settings, $AutoHideTaskbar, "Auto Hide Taskbar", "Taskbar", "AutoHideTaskbar", 220, 325, 160, 15)
	_IniReadCheckbox ($settings, $KeepTaskbarOnTop, "Keep taskbar on top", "Taskbar", "KeepTaskbarOnTop", 220, 340, 160, 15)
	_IniReadCheckbox ($settings, $Group, "Group", "Taskbar", "Group", 220, 355, 160, 15)
	_IniReadCheckbox ($settings, $ShowQuickLaunch, "Show Quick Launch", "Taskbar", "ShowQuickLaunch", 220, 370, 160, 15)
	_IniReadCheckbox ($settings, $ShowClock, "Show Clock", "Taskbar", "ShowClock", 220, 385, 160, 15)
	_IniReadCheckbox ($settings, $HideInactiveIcons, "Hide Inactive Icons", "Taskbar", "HideInactiveIcons", 220, 400, 160, 15)
	
	GUICtrlCreateGroup("Folder Options", 400, 85, 180, 340)
	_IniReadCheckbox ($settings, $SearchNetPrinters, "Auto Search Network Printers", "Folder_Options", "SearchNetPrinters", 405, 105, 170, 15)
	_IniReadCheckbox ($settings, $DisplayFileSizeInFolderTips, "Display File Size In FolderTips", "Folder_Options", "DisplayFileSizeInFolderTips", 405, 120, 170, 15)
	_IniReadCheckbox ($settings, $SimpleViewInFolderListView, "Simple View In Folder List View", "Folder_Options", "SimpleViewInFolderListView", 405, 135, 170, 15)
	_IniReadCheckbox ($settings, $DisplaySystemFolderContents, "Display System Folder Contents", "Folder_Options", "DisplaySystemFolderContents", 405, 150, 170, 15)
	_IniReadCheckbox ($settings, $FullPathAddress, "Full Path in Address Bar", "Folder_Options", "FullPathAddress", 405, 165, 160, 15)
	_IniReadCheckbox ($settings, $FullPathTitle, "Full Path in Title", "Folder_Options", "FullPathTitle", 405, 180, 160, 15)
	_IniReadCheckbox ($settings, $CacheThumbnails, "Cache Thumbnails", "Folder_Options", "CacheThumbnails", 405, 195, 160, 15)
	_IniReadCheckbox ($settings, $ShowHiddenFiles, "Show Hidden Files", "Folder_Options", "ShowHiddenFiles", 405, 210, 160, 15)
	_IniReadCheckbox ($settings, $ShowFileExtensions, "Show File Extensions", "Folder_Options", "ShowFileExtensions", 405, 225, 160, 15)
	_IniReadCheckbox ($settings, $ShowHiddenSysFiles, "Show Hidden Sys Files", "Folder_Options", "ShowHiddenSysFiles", 405, 240, 160, 15)
	_IniReadCheckbox ($settings, $LaunchWindowsInSeperateProcess, "Launch Windows In Seperate Process", "Folder_Options", "LaunchWindowsInSeperateProcess", 405, 255, 160, 15)
	_IniReadCheckbox ($settings, $RememberFolderSettings, "Remember Folder Settings", "Folder_Options", "RememberFolderSettings", 405, 270, 160, 15)
	_IniReadCheckbox ($settings, $RestoreWindowsAtLogon, "Restore Windows At Logon", "Folder_Options", "RestoreWindowsAtLogon", 405, 285, 160, 15)
	_IniReadCheckbox ($settings, $ControlPanelInMyComputer, "Control Panel In My Computer", "Folder_Options", "ControlPanelInMyComputer", 405, 300, 160, 15)
	_IniReadCheckbox ($settings, $ShowCompressedFilesInColor, "Show Compressed Files In Color", "Folder_Options", "ShowCompressedFilesInColor", 405, 315, 173, 15)
	_IniReadCheckbox ($settings, $ShowDesktopFolderInfoPopop, "Show Desktop Folder Info Popop", "Folder_Options", "ShowDesktopFolderInfoPopop", 405, 330, 173, 15)
	_IniReadCheckbox ($settings, $UseSimpleFileSharing, "Use Simple File Sharing", "Folder_Options", "UseSimpleFileSharing", 405, 345, 160, 15)



	$tab4 = GUICtrlCreateTabItem("Visual");--->Visual Settings Tab
	If $opentab[2] = 4 Then GUICtrlSetState(-1, $GUI_SHOW)

	GUICtrlCreateGroup("Visual Settings", 5, 85, 245, 250)
	_IniReadCheckbox ($settings, $AWWMAM, "Animate windows when min & maxing", "Visual_Effects", "AWWMAM", 10, 105, 220, 15)
	_IniReadCheckbox ($settings, $FOSMIV, "Fade or slide menus into view", "Visual_Effects", "FOSMIV", 10, 120, 220, 15)
	_IniReadCheckbox ($settings, $FOSTIV, "Fade or slide tooltips into view", "Visual_Effects", "FOSTIV", 10, 135, 220, 15)
	_IniReadCheckbox ($settings, $SSUM, "Show shadows under menu", "Visual_Effects", "SSUM", 10, 150, 220, 15)
	_IniReadCheckbox ($settings, $SSUMP, "Show shadows under mouse pointer", "Visual_Effects", "SSUMP", 10, 165, 220, 15)
	_IniReadCheckbox ($settings, $STSR, "Show translucent selection rectangle", "Visual_Effects", "STSR", 10, 180, 220, 15)
	_IniReadCheckbox ($settings, $SWCWD, "Show window contents while dragging", "Visual_Effects", "SWCWD", 10, 195, 220, 15)
	_IniReadCheckbox ($settings, $SOCB, "Slide open combo boxes", "Visual_Effects", "SOCB", 10, 210, 220, 15)
	_IniReadCheckbox ($settings, $STB, "Slide taskbar buttons", "Visual_Effects", "STB", 10, 225, 220, 15)
	_IniReadCheckbox ($settings, $SEOSF, "Smooth edges of screen fonts", "Visual_Effects", "SEOSF", 10, 240, 220, 15)
	_IniReadCheckbox ($settings, $SSLB, "Smoth-scroll list boxes", "Visual_Effects", "SSLB", 10, 255, 220, 15)
	_IniReadCheckbox ($settings, $UABIFEFT, "Use a background image for each folder type", "Visual_Effects", "UABIFEFT", 10, 270, 235, 15)
	_IniReadCheckbox ($settings, $UCTIF, "Use common task in folders", "Visual_Effects", "UCTIF", 10, 285, 220, 15)
	_IniReadCheckbox ($settings, $UDSFILOTD, "Use drop shadows for icon lables on desktop", "Visual_Effects", "UDSFILOTD", 10, 300, 230, 15)
	_IniReadCheckbox ($settings, $UVSOWAB, "Use visual styles on windows and buttons", "Visual_Effects", "UVSOWAB", 10, 315, 220, 15)
	;Desktop Settings GUI
	GUICtrlCreateGroup("Desktop Image", 5, 340, 470, 95)
	$imglab1 = GUICtrlCreateLabel("Default Image:", 10, 360, 85, 15)
	$defaultimgname = GUICtrlCreateInput($defaultimgname, 100, 360, 335, 20)
	$imgbrowse1 = GUICtrlCreateButton("...", 445, 360, 20, 20)
	_IniReadCheckbox ($settings, $use_local_image, "Use Local Image", "Program_Use_Only", "UseLocalImage", 10, 385, 125, 15)
	$imglab2 = GUICtrlCreateLabel("Local image:", 10, 410, 85, 15)
	$localimgname = GUICtrlCreateInput($localimgname, 100, 410, 335, 20)
	$imgbrowse2 = GUICtrlCreateButton("...", 445, 410, 20, 20)
	GUICtrlCreateGroup("Desktop Icons", 255, 85, 140, 100)
	_IniReadCheckbox ($settings, $mydocs, "My Doucuments", "Desktop_Items", "My_Documents", 260, 105, 95, 15)
	_IniReadCheckbox ($settings, $mycomp, "My Computer", "Desktop_Items", "My_Computer", 260, 120, 95, 15)
	_IniReadCheckbox ($settings, $mynetplaces, "My Network Places", "Desktop_Items", "My_Network_Places", 260, 135, 110, 15)
	_IniReadCheckbox ($settings, $iexplorer, "Internet Explorer", "Desktop_Items", "My_Network_Places", 260, 150, 110, 15)
	_IniReadCheckbox ($settings, $cleandesk, "Cleanup desktop", "Desktop_Items", "Enable_Desktop_Cleanup", 260, 165, 110, 15)

	$tab6 = GUICtrlCreateTabItem("Programs") ;--->Program Locations Tab
	If $opentab[2] = 6 Then GUICtrlSetState(-1, $GUI_SHOW)


	GUICtrlCreateLabel("McAffee Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 85, 325, 15)
	_FileBrowse ($mcafee_exe, $mcafee_exe2, $browse1, 10, 100, 520, 20, 540, 30)
	GUICtrlCreateLabel("McAffee Patch Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 120, 325, 15)
	_FileBrowse ($mcafee_patch_exe, $mcafee_patch_exe2, $browse2, 10, 135, 520, 20, 540, 30)
	GUICtrlCreateLabel("Sophos Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 155, 325, 15)
	_FileBrowse ($sophos_exe, $sophos_exe2, $browse3, 10, 170, 520, 20, 540, 30)
	GUICtrlCreateLabel("VPN Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 190, 325, 15)
	_FileBrowse ($vpn_exe, $vpn_exe2, $browse4, 10, 205, 520, 20, 540, 30)
	GUICtrlCreateLabel("Office Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 225, 440, 15)
	_FileBrowse ($office_exe, $office_exe2, $browse5, 10, 240, 520, 20, 540, 30)
	GUICtrlCreateLabel("Datatel Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 260, 325, 15)
	_FileBrowse ($datatel_exe, $datatel_exe2, $browse6, 10, 275, 520, 20, 540, 30)
	GUICtrlCreateLabel("DeepFreeze Auto Install Location (.exe;.bat;.cmd;.msi)", 10, 295, 325, 15)
	_FileBrowse ($deepfreeze_exe, $deepfreeze_exe2, $browse7, 10, 310, 520, 20, 540, 30)
	GUICtrlCreateLabel("CleanSMS Auto Run Location (.exe;.bat;.cmd;.msi)", 10, 330, 325, 15)
	_FileBrowse ($cleansms_exe, $cleansms_exe2, $browse8, 10, 345, 520, 20, 540, 30)
	GUICtrlCreateLabel("Windows Installer Auto Run Location (.exe;.bat;.cmd;.msi)", 10, 365, 325, 15)
	_FileBrowse ($wininstaller_exe, $wininstaller_exe2, $browse9, 10, 380, 520, 20, 540, 30)
	$toolbar_group = GUICtrlCreateGroup("Office Toolbar Directory", 5, 410, 470, 40)
	$toolbardir2 = GUICtrlCreateInput($toolbardir, 10, 425, 460, 20)

	$tab7 = GUICtrlCreateTabItem("Extra Program(s)") ;--->Extra Program Locations Tab
	If $opentab[2] = 7 Then GUICtrlSetState(-1, $GUI_SHOW)

	$extralist = GUICtrlCreateListView("Auto Installs", 10, 85, 565, 350, $LVS_EDITLABELS)
	_GUICtrlListViewSetColumnWidth($extralist, 0, 560)
	_IniReadCheckbox ($settings, $extrareboot, "Reboot when done", "Program_Use_Only", "ExtraInstallReboot", 230, 440, 110, 20)
	;$extrareboot = GuiCtrlCreateCheckbox("Reboot when done", 140, 320, 110, 20)
	$addautorun = GUICtrlCreateButton("Add Extra Autorun", 110, 470, 180, 20)
	$deleteautorun = GUICtrlCreateButton("Delete Selected Autorun(s)", 290, 470, 180, 20)

	$ExtraAutoRuns = IniReadSection($settings, "ExtraAutoRuns")
	If Not @error Then
		For $i = 1 To $ExtraAutoRuns[0][0]
			GUICtrlCreateListViewItem($ExtraAutoRuns[$i][1], $extralist)
		Next
	EndIf

	GUICtrlCreateTabItem("")   ; end tabitem definition
	_PrepsysToStartup ()
	_StartMenuState ()
	_StartMenuSwitch ()
	_VisSettings_State ()
	_Office_State ()
	_Sophos_State ()
	_McAfee_State ()
	_Sysprep_User_State ()
	_Folder_Options_State ()
	_JoinDomainState ()

	
	GUISetState(@SW_SHOW)
	While 1
		$msg = GUIGetMsg()
		Select
			Case $msg = $UseServiceTagAsName
				If GUICtrlRead($UseServiceTagAsName) = 1 Then
					$service_tag = _GetServiceTagFromWMI ()
					GUICtrlSetData($machine_name, "D" & $service_tag)
					GUICtrlSetState($machine_name, $GUI_DISABLE)
				Else
					GUICtrlSetData($machine_name, $machine_name_orig)
					GUICtrlSetState($machine_name, $GUI_ENABLE)
				EndIf
			Case $msg = $joindomain
				_JoinDomainState ()
			Case $msg = $Classic_Menu
				_StartMenuSwitch ()
			Case $msg = $use_local_image
				_LocalImage_State ()
			Case $msg = $spinstall
				_McAfee_State ()
			Case $msg = $mcinstall
				_Sophos_State ()
			Case $msg = $addofficetoolbar
				_Office_State ()
			Case $msg = $startmenu
				_StartMenuState ()
				_StartMenuSwitch ()
			Case $msg = $vissettings
				_VisSettings_State ()
			Case $msg = $folderoptions
				_Folder_Options_State ()
			Case $msg = $copyprofile
				_Sysprep_User_State ()
			Case $msg = $addprepsystostartup
				_PrepsysToStartup ()
			Case $msg = $AddCompDomain
				$temp = InputBox("Enter Domain", "Enter Domain")
				If Not @error Then
					_ArrayAdd($AdminDomains, $temp)
					$AdminDomains[0] = UBound($AdminDomains) - 1
					GUICtrlSetData($domain, "")
					For $i = 1 To $AdminDomains[0]
						GUICtrlSetData($domain, $AdminDomains[$i], $AdminDomains[$i])
					Next
				EndIf
			Case $msg = $AddCompDomain2
				$temp = InputBox("Enter Domain", "Enter Domain")
				If Not @error Then
					_ArrayAdd($CPDomains, $temp)
					$CPDomains[0] = UBound($CPDomains) - 1
					GUICtrlSetData($domain2, "")
					For $i = 1 To $CPDomains[0]
						GUICtrlSetData($domain2, $CPDomains[$i], $CPDomains[$i])
					Next
				EndIf
			Case $msg = $RemCompDomain
				For $i = 1 To $AdminDomains[0]
					If $AdminDomains[$i] = GUICtrlRead($domain) Then
						_ArrayDelete($AdminDomains, $i)
						$AdminDomains[0] = UBound($AdminDomains) - 1
						;_ArrayDisplay($OU_User_Domains, "")
						GUICtrlSetData($domain, "")
						ExitLoop
					EndIf
				Next
				For $i = 1 To $AdminDomains[0]
					GUICtrlSetData($domain, $AdminDomains[$i], $AdminDomains[$i])
				Next
			Case $msg = $RemCompDomain2
				For $i = 1 To $CPDomains[0]
					If $CPDomains[$i] = GUICtrlRead($domain2) Then
						_ArrayDelete($CPDomains, $i)
						$CPDomains[0] = UBound($CPDomains) - 1
						;_ArrayDisplay($OU_User_Domains, "")
						GUICtrlSetData($domain2, "")
						ExitLoop
					EndIf
				Next
				For $i = 1 To $CPDomains[0]
					GUICtrlSetData($domain2, $CPDomains[$i], $CPDomains[$i])
				Next
			Case $msg = $MakeJDUserAdmin Or $msg = $UseJDUserAsDefaultAdmin Or $msg = $UseJDUserAsCopyProfileUser
				_JoinDomainState ()
			Case $msg = $OU_AddUserDomain
				$temp = InputBox("Enter Domain", "Enter Domain")
				If Not @error Then
					_ArrayAdd($OUuserdomains, $temp)
					$OUuserdomains[0] = UBound($OUuserdomains) - 1
					GUICtrlSetData($JD_domain, "")
					For $i = 1 To $OUuserdomains[0]
						GUICtrlSetData($JD_domain, $OUuserdomains[$i], $OUuserdomains[$i])
					Next
				EndIf
			Case $msg = $OU_RemoveUserDomain
				For $i = 1 To $OUuserdomains[0]
					If $OUuserdomains[$i] = GUICtrlRead($JD_domain) Then
						_ArrayDelete($OUuserdomains, $i)
						$OUuserdomains[0] = UBound($OUuserdomains) - 1
						;_ArrayDisplay($OU_User_Domains, "")
						GUICtrlSetData($JD_domain, "")
						ExitLoop
					EndIf
				Next
				For $i = 1 To $OUuserdomains[0]
					GUICtrlSetData($JD_domain, $OUuserdomains[$i], $OUuserdomains[$i])
				Next
			Case $msg = $editOU
				For $i = 1 To $OUnames[0]
					If $OUnames[$i] = GUICtrlRead($join_to) Then
						GUICreate("Edit OU", 520, 85, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
						GUICtrlCreateLabel("Label:", 10, 10, 30, 20)
						$OuLabel = GUICtrlCreateInput($OUnames[$i], 40, 5, 100, 20)
						GUICtrlCreateLabel("Domain to Join", 150, 10, 70, 20)
						$jointodomain = GUICtrlCreateInput($OUdomain[$i], 225, 5, 255, 20)
						GUICtrlCreateLabel("OU=", 10, 30, 20, 20)
						$ou1 = GUICtrlCreateInput($OUdata[$i], 40, 30, 440, 20)
						$OuAddOk = GUICtrlCreateButton("&OK", 170, 60, 90, 20)
						$OuAddCancle = GUICtrlCreateButton("&Cancle", 300, 60, 90, 20)
						GUISetState()
						While 1
							$msg = GUIGetMsg()
							Select
								Case $msg = $OuAddOk
									$OUnames[$i] = GUICtrlRead($OuLabel)
									$OUdomain[$i] = GUICtrlRead($jointodomain)
									$OUdata[$i] = GUICtrlRead($ou1)
									$OUnames[0] = UBound($OUnames) - 1
									$OUdomain[0] = UBound($OUdomain) - 1
									$OUdata[0] = UBound($OUnames) - 1
									GUICtrlSetData($join_to, "")
									For $i = 1 To $OUnames[0]
										GUICtrlSetData($join_to, $OUnames[$i], $OUnames[$i])
									Next
									ExitLoop
								Case $msg = $GUI_EVENT_CLOSE Or $msg = $OuAddCancle
									ExitLoop
								Case Else
									;;;
							EndSelect
						WEnd
						GUISetState("Edit OU")
					EndIf
				Next
			Case $msg = $removeOU
				For $i = 1 To $OUnames[0]
					If $OUnames[$i] = GUICtrlRead($join_to) Then
						_ArrayDelete($OUnames, $i)
						_ArrayDelete($OUdomain, $i)
						_ArrayDelete($OUdata, $i)
						$OUnames[0] = UBound($OUnames) - 1
						$OUdomain[0] = UBound($OUdomain) - 1
						$OUdata[0] = UBound($OUnames) - 1
						;_ArrayDisplay($OUnames, "")
						GUICtrlSetData($join_to, "")
						ExitLoop
					EndIf
				Next
				For $i = 1 To $OUnames[0]
					GUICtrlSetData($join_to, $OUnames[$i], $OUnames[$i])
				Next
			Case $msg = $addOU
				GUICreate("Add OU", 520, 85, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
				
				GUICtrlCreateLabel("Label:", 10, 10, 30, 20)
				$OuLabel = GUICtrlCreateInput("", 40, 5, 100, 20)
				GUICtrlCreateLabel("Domain to Join", 150, 10, 70, 20)
				$jointodomain = GUICtrlCreateInput("", 225, 5, 255, 20)
				GUICtrlCreateLabel("OU=", 10, 30, 20, 20)
				$ou1 = GUICtrlCreateInput("", 40, 30, 440, 20)
				$OuAddOk = GUICtrlCreateButton("&OK", 170, 60, 90, 20)
				$OuAddCancle = GUICtrlCreateButton("&Cancle", 300, 60, 90, 20)
				
				GUISetState()
				While 1
					$msg = GUIGetMsg()
					Select
						Case $msg = $OuAddOk
							_ArrayAdd($OUnames, GUICtrlRead($OuLabel))
							_ArrayAdd($OUdomain, GUICtrlRead($jointodomain))
							_ArrayAdd($OUdata, GUICtrlRead($ou1))
							$OUnames[0] = UBound($OUnames) - 1
							$OUdomain[0] = UBound($OUdomain) - 1
							$OUdata[0] = UBound($OUnames) - 1
							;_ArrayDisplay($OUnames, "")
							For $i = 1 To $OUnames[0]
								GUICtrlSetData($join_to, $OUnames[$i], $OUnames[$i])
							Next
							ExitLoop
						Case $msg = $GUI_EVENT_CLOSE Or $msg = $OuAddCancle
							ExitLoop
						Case Else
							;;;
					EndSelect
				WEnd
				GUIDelete("Add OU")
			Case $msg = $addautorun
				$extrafile = _AdvancedFileOpenDialog ('Choose AutoRun File', $workingdir, 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 1 + 4)
				If $extrafile <> '' Then GUICtrlCreateListViewItem($extrafile, $extralist)
			Case $msg = $deleteautorun
				If GUICtrlRead($extralist) <> 0 Then _GUICtrlListViewDeleteItemsSelected($extralist)
			Case $msg = $browse1 Or $msg = $browse2 Or $msg = $browse3 Or $msg = $browse4 Or $msg = $browse5 Or $msg = $browse6 Or $msg = $browse7 Or $msg = $browse8 Or $msg = $browse9 Or $msg = $imgbrowse1 Or $msg = $imgbrowse2
				If $msg = $browse1 Then _FileBrowseSet ($mcafee_exe2, 'McAfee Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse2 Then _FileBrowseSet ($mcafee_patch_exe2, 'McAfee Patch Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse3 Then _FileBrowseSet ($sophos_exe2, 'Sophos Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse4 Then _FileBrowseSet ($vpn_exe2, 'VPN Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse5 Then _FileBrowseSet ($office_exe2, 'Office Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse6 Then _FileBrowseSet ($datatel_exe2, 'Datatel Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse7 Then _FileBrowseSet ($deepfreeze_exe2, 'DeepFreeze Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse8 Then _FileBrowseSet ($cleansms_exe2, 'CleanSMS Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $browse9 Then _FileBrowseSet ($wininstaller_exe2, 'Windows Installer Exe', 'AutoInstall (*.exe;*.bat;*.cmd;*.msi)', 'advanced')
				If $msg = $imgbrowse1 Then _FileBrowseSet ($defaultimgname, 'Default Image Location', 'Background Image(*.bmp)', 'normal')
				If $msg = $imgbrowse2 Then _FileBrowseSet ($localimgname, 'Local Image Location', 'Background Image(*.bmp)', 'normal')
				
			Case $msg = $load_ini
				$settingsfile = GUICtrlRead($inifile_browse)
				If StringInStr($settingsfile, ":") = 0 And StringInStr($settingsfile, "\\") = 0 Then ;if full path for settings file is not given, assume file is in @scriptdir/settings/
					$settings = @ScriptDir & "\settings\" & $settingsfile
				Else
					$settings = $settingsfile
				EndIf
				
				ExitLoop
			Case $msg = $bowse_ini Or $msg = $BrowseSettingsFile
				$file = FileOpenDialog("Choose a settings file", @ScriptDir & "\settings", "Settings (*.ini)", 1 + 4)
				If Not @error Then
					If $msg = $bowse_ini Then
						GUICtrlSetData($inifile_browse, $file, $file)
						GUICtrlSetData($APTS_settingsfile_Combo, $file)
					ElseIf $msg = $BrowseSettingsFile Then
						GUICtrlSetData($inifile_browse, $file)
						GUICtrlSetData($APTS_settingsfile_Combo, $file, $file)
					EndIf
					_ArrayAdd($settingslist, $file)
					$settingslist[0] = UBound($settingslist) - 1
				EndIf
			Case $msg = $save_ini
				_Set_INI_Settings ($settings, $workingdir)
				MsgBox(0, "Ini Saved", "Ini Saved As: " & $settings)
			Case $msg = $save_ini_as
				$saveinias = FileSaveDialog("Save settings file as ...", @ScriptDir & "\settings", "Settings (*.ini)")
				If @error Then
					MsgBox(0, "Error", "No file was saved")
				Else
					If Not StringInStr($saveinias, ".ini") Then $saveinias = $saveinias & ".ini"
					_Set_INI_Settings ($saveinias, $workingdir)
					MsgBox(0, "Ini Saved", "Ini Saved As: " & $saveinias)
				EndIf
			Case $msg = $new_ini
			Case $msg = $setinirun Or $AutoRunPrepSys = 1
				If GUICtrlRead($vissettings) = 1 Then
					If StringInStr(GUICtrlRead($defaultimgname), "\\") = 0 And StringInStr(GUICtrlRead($defaultimgname), ":") = 0 Then
						$defaultimg = $workingdir & GUICtrlRead($defaultimgname)
						FileCopy($defaultimg, @HomeDrive & "\defaultimg.bmp", 9)
					Else
						FileCopy(GUICtrlRead($defaultimgname), @HomeDrive & "\defaultimg.bmp")
					EndIf
				EndIf
				FileCopy(@ScriptDir & "\Prepsys\_no_gui.exe", $no_gui_exe, 9)
				_Set_INI_Settings (@HomeDrive & '\settings.ini', $workingdir)
				Run($no_gui_exe)
				Exit
			Case $msg = $GUI_EVENT_CLOSE Or $msg = $exit_prepsys
				Exit
			Case Else
				;;;
		EndSelect
	WEnd
	GUIDelete()
	;EndFunc   ;==>_XP_Load_Settings
EndFunc   ;==>_XP_Prepsys